﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class CustomerPropertySyntax
    Private custAccount As String
    Private custFirstName As String
    Private custLastName As String

    Sub New(ByVal AccountNumber As String)

        '这是此类的构造函数。

        '通常使用 AccountNumber 字符串在
        '数据库或集合中搜索客户的帐号。
        '这里我们只准备向 Customer 对象填充
        '虚拟数据。
        '
        '由于帐号是一个 ReadOnly 属性，
        '因此，我们需要直接设置私有 custAccount 变量，
        '而不是调用属性过程。
        custAccount = "1101"
        Me.FirstName = "Carmen"
        Me.LastName = "Smith"

    End Sub

    '下一行是
    'AccountNumber 属性的属性声明。此行
    '称为“属性语句”。
    Public ReadOnly Property AccountNumber() As String

        '大节属性都是可读/写的，这意味着
        '通过调用代码可以对这些属性进行计算或更改。
        '当属性可读/写时，在
        '属性代码内既有 Get 部分又有 Set 部分。
        '属性的 Get 和 Set 部分
        '称为“属性
        '过程”。

        '由于此属性被标记为 ReadOnly，因此
        '只有一个 Get 属性过程，没有匹配的
        '“Set”属性过程。

        '此外，可以声明属性为“WriteOnly”而
        '不是 ReadOnly 来得到一个只写的
        '属性。在这种情况下，您将只有
        'Set 而没有 Get。

        '注意：属性的数据类型和数据访问
        '在 Property 语句中定义，而不是在 Property
        '过程中定义。一个属性只能有一种数据类型
        '和一种可访问性。例如，不能定义
        '一个设置 Decimal 值但获取 Double
        '值的属性。同样，不能对同一属性定义 Private Set 和
        'Public Get。若要实现
        '此功能，可以定义 Public ReadOnly 
        '属性，并在该属性之外定义 Private 设置
        '方法。

        Get
            Return custAccount
        End Get

    End Property

#Region "标准 Customer 属性"

    Public Property FirstName() As String
        Get
            Return custFirstName
        End Get
        Set(ByVal Value As String)
            custFirstName = Value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return custLastName
        End Get
        Set(ByVal Value As String)
            custLastName = Value
        End Set
    End Property
#End Region


End Class
